<div class="modal-dialog" role="document">
  <div class="modal-content">

    <?php echo Form::open(['url' => action('Restaurant\ModifierSetsController@update', [$modifer_set->id]), 'method' => 'PUT', 'id' => 'edit_form' ]); ?>


    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h4 class="modal-title"><?php echo e(app('translator')->getFromJson( 'restaurant.edit_modifier' )); ?></h4>
    </div>

    <div class="modal-body">

      <div class="row">
        
        <div class="col-sm-12">
          <div class="form-group">
            <?php echo Form::label('name', __( 'restaurant.modifier_set' ) . ':*'); ?>

            <?php echo Form::text('name', $modifer_set->name, ['class' => 'form-control', 'required', 'placeholder' => __( 'messages.name' ) ]);; ?>

          </div>
        </div>

        <div class="col-sm-12">
          <h4><?php echo e(app('translator')->getFromJson( 'restaurant.modifiers' )); ?></h4>
        </div>

        <div class="col-sm-12">
          <table class="table table-condensed" id="add-modifier-table">
            <thead>
              <tr>
                <th><?php echo e(app('translator')->getFromJson( 'restaurant.modifier')); ?></th>
                <th>
                  <?php echo e(app('translator')->getFromJson( 'messages.price')); ?>

                  <?php
                    $html = '<tr><td>
                          <div class="form-group">
                            <input type="text" name="modifier_name[]" 
                            class="form-control" 
                            placeholder="' . __( 'messages.name' ) . '" required>
                          </div>
                        </td>
                        <td>
                          <div class="form-group">
                            <input type="text" name="modifier_price[]" class="form-control input_number" 
                            placeholder="' . __( 'messages.price' ) . '" required>
                          </div>
                        </td>
                        <td>
                          <button class="btn btn-danger btn-xs pull-right remove-modifier-row" type="button"><i class="fa fa-minus"></i></button>
                        </td>
                        </tr>';
                  ?>
                </th>
                <th>&nbsp;</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $modifer_set->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td>
                    <div class="form-group">
                      <input type="text" name="modifier_name_edit[<?php echo e($modifier->id); ?>]" 
                        class="form-control" value="<?php echo e($modifier->name); ?>" placeholder="<?php echo e(app('translator')->getFromJson( 'messages.name' )); ?>" required>
                    </div>
                  </td>
                  <td>
                    <div class="form-group">
                      <input type="text" name="modifier_price_edit[<?php echo e($modifier->id); ?>]" 
                      class="form-control input_number" value="<?php echo e(number_format($modifier->sell_price_inc_tax, config('constants.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?>" placeholder="<?php echo e(app('translator')->getFromJson( 'messages.price' )); ?>" required>
                    </div>
                  </td>
                  <td>
                    <?php if(!$loop->first): ?>
                      <button class="btn btn-danger btn-xs pull-right remove-modifier-row" type="button"><i class="fa fa-minus"></i></button>
                    <?php else: ?>
                      <button class="btn btn-primary btn-xs pull-right add-modifier-row" type="button" data-html="<?php echo e($html); ?>">
                        <i class="fa fa-plus"></i>
                      </button>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
    </div>

    <div class="modal-footer">
      <button type="submit" class="btn btn-primary"><?php echo e(app('translator')->getFromJson( 'messages.update' )); ?></button>
      <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(app('translator')->getFromJson( 'messages.close' )); ?></button>
    </div>

    <?php echo Form::close(); ?>


  </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->